package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpaAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageCpcAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyAverageRoiAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumClicksAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyMaximumConversionRateAdd;
import com.yandex.direct.api.v5.campaignsext.StrategyWeeklyClickPackageAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class TextCampaignStrategyAddBaseMap<T> extends ModelBeanMap<TextCampaignStrategyAddBaseMap> {

    public static final String WB_MAXIMUM_CLICKS = "wbMaximumClicks";
    public static final String WB_MAXIMUM_CONVERSION_RATE = "wbMaximumConversionRate";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String WEEKLY_CLICK_PACKAGE = "weeklyClickPackage";
    public static final String AVERAGE_ROI = "averageRoi";

    public TextCampaignStrategyAddBaseMap() {
        super();
    }

    public T withWbMaximumClicks(StrategyMaximumClicksAddMap paramsMap) {
        StrategyMaximumClicksAdd strategyMaximumClicks =
                ((paramsMap == null) ? null : (StrategyMaximumClicksAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CLICKS, strategyMaximumClicks);
        return (T) this;
    }

    public T withWbMaximumConversionRate(StrategyMaximumConversionRateAddMap paramsMap) {
        StrategyMaximumConversionRateAdd params =
                ((paramsMap == null) ? null : (StrategyMaximumConversionRateAdd) (paramsMap.getBean()));
        this.put(WB_MAXIMUM_CONVERSION_RATE, params);
        return (T) this;
    }

    public T withAverageCpc(StrategyAverageCpcAddMap paramsMap) {
        StrategyAverageCpcAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC, params);
        return (T) this;
    }

    public T withAverageCpa(StrategyAverageCpaAddMap paramsMap) {
        StrategyAverageCpaAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpaAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPA, params);
        return (T) this;
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageAddMap paramsMap) {
        StrategyWeeklyClickPackageAdd params =
                ((paramsMap == null) ? null : (StrategyWeeklyClickPackageAdd) (paramsMap.getBean()));
        this.put(WEEKLY_CLICK_PACKAGE, params);
        return (T) this;
    }

    public T withAverageRoi(StrategyAverageRoiAddMap paramsMap) {
        StrategyAverageRoiAdd params =
                ((paramsMap == null) ? null : (StrategyAverageRoiAdd) (paramsMap.getBean()));
        this.put(AVERAGE_ROI, params);
        return (T) this;
    }
}
