package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.TextCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaignsext.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.TextCampaignStrategy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class TextCampaignStrategyMap extends ModelBeanMap<TextCampaignStrategyMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public TextCampaignStrategyMap() {
        super();
        setBean(new TextCampaignStrategy());
    }

    public TextCampaignStrategyMap(TextCampaignStrategy textCampaignStrategy) {
        super();
        setBean(textCampaignStrategy);
    }

    public TextCampaignStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TextCampaignStrategyMap withSearch(TextCampaignSearchStrategyMap textCampaignSearchStrategyMap) {
        TextCampaignSearchStrategy textCampaignSearchStrategy =
                ((textCampaignSearchStrategyMap == null) ? null
                        : (com.yandex.direct.api.v5.campaignsext.TextCampaignSearchStrategy) (textCampaignSearchStrategyMap
                                .getBean()));
        this.put(SEARCH, textCampaignSearchStrategy);
        return this;
    }

    public TextCampaignStrategyMap withNetwork(TextCampaignNetworkStrategyMap textCampaignNetworkStrategyMap) {
        TextCampaignNetworkStrategy textCampaignNetworkStrategy =
                ((textCampaignNetworkStrategyMap == null) ? null
                        : (TextCampaignNetworkStrategy) (textCampaignNetworkStrategyMap.getBean()));
        this.put(NETWORK, textCampaignNetworkStrategy);
        return this;
    }

    public TextCampaignStrategyMap defaultTextCampaignStrategy() {
        return this
                .withSearch(new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new TextCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE));
    }
}
