package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.general.ArrayOfString;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfStringMap;

/**
 * Created by pavryabov on 15.08.15.
 */
public class TimeTargetingBaseMap<T> extends ModelBeanMap<TimeTargetingBaseMap> {

    public static final String SCHEDULE = "schedule";
    public static final String CONSIDER_WORKING_WEEKENDS = "considerWorkingWeekends";

    public static final String[] DEFAULT_SCHEDULE = {
            "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "3,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "4,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "5,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "6,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "7,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
    };

    public static final String[] CPM_BANNER_DEFAULT_SCHEDULE = {
            "1,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "2,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "7,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100"
    };

    public TimeTargetingBaseMap() {
        super();
    }

    public T withSchedule(ArrayOfStringMap arrayOfStringMap) {
        ArrayOfString schedule =
                (ArrayOfString) ((arrayOfStringMap == null) ? null : arrayOfStringMap.getBean());
        this.put(SCHEDULE, schedule);
        return (T) this;
    }

    public T withSchedule(String... items) {
        return this.withSchedule(new ArrayOfStringMap().withItems(items));
    }

    public T withConsiderWorkingWeekends(YesNoEnum considerWorkingWeekends) {
        this.put(CONSIDER_WORKING_WEEKENDS, considerWorkingWeekends);
        return (T) this;
    }
}
