package ru.yandex.autotests.directapi.model.api5.campaignsext;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaignsext.ObjectFactory;
import com.yandex.direct.api.v5.campaignsext.TimeTargeting;
import com.yandex.direct.api.v5.campaignsext.TimeTargetingOnPublicHolidays;

/**
 * Created by pavryabov on 15.08.15.
 */
public class TimeTargetingMap extends TimeTargetingBaseMap<TimeTargetingMap> {

    public static final String HOLIDAYS_SCHEDULE = "holidaysSchedule";

    public TimeTargetingMap() {
        super();
        setBean(new TimeTargeting());
    }

    public TimeTargetingMap(TimeTargeting timeTargeting) {
        super();
        setBean(timeTargeting);
    }

    public TimeTargetingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TimeTargetingMap withHolidaysSchedule(TimeTargetingOnPublicHolidaysMap timeTargetingOnPublicHolidaysMap) {
        TimeTargetingOnPublicHolidays timeTargetingOnPublicHolidays =
                (TimeTargetingOnPublicHolidays) ((timeTargetingOnPublicHolidaysMap == null)
                        ? null : timeTargetingOnPublicHolidaysMap.getBean());
        JAXBElement<TimeTargetingOnPublicHolidays> jaxbElement =
                new ObjectFactory().createTimeTargetingHolidaysSchedule(timeTargetingOnPublicHolidays);
        this.put(HOLIDAYS_SCHEDULE, jaxbElement);
        return this;
    }
}
