package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.TimeTargetingOnPublicHolidays;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 15.08.15.
 */
public class TimeTargetingOnPublicHolidaysMap extends ModelBeanMap<TimeTargetingOnPublicHolidaysMap> {

    public static final String SUSPEND_ON_HOLIDAYS = "suspendOnHolidays";
    public static final String START_HOUR = "startHour";
    public static final String END_HOUR = "endHour";
    public static final String BID_PERCENT = "bidPercent";

    public static final int MIN_BID_PERCENT = 10;
    public static final int MAX_BID_PERCENT = 200;
    public static final int DEFAULT_BID_PERCENT = 100;

    public TimeTargetingOnPublicHolidaysMap() {
        super();
        setBean(new TimeTargetingOnPublicHolidays());
    }

    public TimeTargetingOnPublicHolidaysMap(TimeTargetingOnPublicHolidays timeTargetingOnPublicHolidays) {
        super();
        setBean(timeTargetingOnPublicHolidays);
    }

    public TimeTargetingOnPublicHolidaysMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withSuspendOnHolidays(YesNoEnum suspendOnHolidays) {
        this.put(SUSPEND_ON_HOLIDAYS, suspendOnHolidays);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withStartHour(Integer startHour) {
        this.put(START_HOUR, startHour);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withEndHour(Integer endHour) {
        this.put(END_HOUR, endHour);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withBidPercent(Integer bidPercent) {
        this.put(BID_PERCENT, bidPercent);
        return this;
    }
}
