package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.UnarchiveRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by chicos on 18.08.15.
 */
public class UnarchiveRequestMap extends ModelBeanMap<UnarchiveRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public UnarchiveRequestMap() {
        super();
        setBean(new UnarchiveRequest());
    }

    public UnarchiveRequestMap(UnarchiveRequest unarchiveRequest) {
        super();
        setBean(unarchiveRequest);
    }

    public UnarchiveRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UnarchiveRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
