package ru.yandex.autotests.directapi.model.api5.campaignsext;

import com.yandex.direct.api.v5.campaignsext.UpdateRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 21.08.15.
 */
public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {

    public static final String CAMPAIGNS = "campaigns";

    public static final int MAX_AMOUNT_OF_CAMPAIGNS_IN_REQUEST = 10;

    public UpdateRequestMap() {
        super();
        setBean(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest updateRequest) {
        super();
        setBean(updateRequest);
    }

    public UpdateRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public UpdateRequestMap withCampaigns(CampaignUpdateItemMap... campaignsext) {
        this.put(CAMPAIGNS, (campaignsext == null) ? null : convert(campaignsext, new BeanMapToBeanConverter()));
        return this;
    }
}
