package ru.yandex.autotests.directapi.model.api5.changes;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 30.03.15.
 */
public class CampaignChangesItemMap extends ModelBeanMap<CampaignChangesItemMap> {

    public static final String CAMPAIGN_ID = "campaignId";
    public static final String CHANGES_IN = "changesIn";


    public CampaignChangesItemMap() {
        super();
        setBean(new CampaignChangesItem());
    }

    public CampaignChangesItemMap(CampaignChangesItem campaignChangesItem) {
        super();
        setBean(campaignChangesItem);
    }

    public CampaignChangesItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CampaignChangesItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public CampaignChangesItemMap withChangesIn(CampaignChangesInEnum... campaignChangesInEnum) {
        this.put(CHANGES_IN, Arrays.asList(campaignChangesInEnum));
        return this;
    }
}
