package ru.yandex.autotests.directapi.model.api5.changes;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 30.03.15.
 */
public class CheckRequestMap extends ModelBeanMap<CheckRequestMap> {

    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String AD_IDS = "adIds";
    public static final String TIMESTAMP = "timestamp";
    public static final String FIELD_NAMES = "fieldNames";

    public CheckRequestMap() {
        super();
        setBean(new CheckRequest());
    }

    public CheckRequestMap(CheckRequest checkRequest) {
        super();
        setBean(checkRequest);
    }

    public CheckRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CheckRequestMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public CheckRequestMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public CheckRequestMap withAdIds(Long... adIds) {
        this.put(AD_IDS, Arrays.asList(adIds));
        return this;
    }

    public CheckRequestMap withTimestamp(String timestamp) {
        this.put(TIMESTAMP, timestamp);
        return this;
    }

    public CheckRequestMap withFieldNames(CheckFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

}
