package ru.yandex.autotests.directapi.model.api5.changes;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CheckResponseIds;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 06.05.15.
 */
public class CheckResponseIdsMap extends ModelBeanMap<CheckResponseIdsMap> {

    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String AD_IDS = "adIds";

    public CheckResponseIdsMap() {
        super();
        setBean(new CheckResponseIds());
    }

    public CheckResponseIdsMap(CheckResponseIds checkResponseIds) {
        super();
        setBean(checkResponseIds);
    }

    public CheckResponseIdsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CheckResponseIdsMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public CheckResponseIdsMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public CheckResponseIdsMap withAdIds(Long... adIds) {
        this.put(AD_IDS, Arrays.asList(adIds));
        return this;
    }

}
