package ru.yandex.autotests.directapi.model.api5.changes;

import com.yandex.direct.api.v5.changes.CheckResponse;
import com.yandex.direct.api.v5.changes.CheckResponseIds;
import com.yandex.direct.api.v5.changes.CheckResponseModified;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 26.04.15.
 */
public class CheckResponseMap extends ModelBeanMap<CheckResponseMap> {

    public static final String MODIFIED = "modified";
    public static final String NOT_FOUND = "notFound";
    public static final String UNPROCESSED = "unprocessed";
    public static final String TIMESTAMP = "timestamp";

    public CheckResponseMap() {
        super();
        setBean(new CheckResponse());
    }

    public CheckResponseMap(CheckResponse checkResponse) {
        super();
        setBean(checkResponse);
    }

    public CheckResponseMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CheckResponseMap withModified(CheckResponseModified modified) {
        this.put(MODIFIED, modified);
        return this;
    }

    public CheckResponseMap withNotFound(CheckResponseIds notfound) {
        this.put(NOT_FOUND, notfound);
        return this;
    }

    public CheckResponseMap withUnprocessed(CheckResponseIds unprocessed) {
        this.put(UNPROCESSED, unprocessed);
        return this;
    }

    public CheckResponseMap withTimestamp(String timestamp) {
        this.put(TIMESTAMP, timestamp);
        return this;
    }

}
