package ru.yandex.autotests.directapi.model.api5.changes;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignStatItem;
import com.yandex.direct.api.v5.changes.CheckResponseModified;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 06.05.15.
 */
public class CheckResponseModifiedMap extends ModelBeanMap<CheckResponseModifiedMap> {

    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String AD_IDS = "adIds";
    public static final String CAMPAIGN_STAT = "campaignsStat";

    public CheckResponseModifiedMap() {
        super();
        setBean(new CheckResponseModified());
    }

    public CheckResponseModifiedMap(CheckResponseModified checkResponseModified) {
        super();
        setBean(checkResponseModified);
    }

    public CheckResponseModifiedMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CheckResponseModifiedMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public CheckResponseModifiedMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public CheckResponseModifiedMap withAdIds(Long... adIds) {
        this.put(AD_IDS, Arrays.asList(adIds));
        return this;
    }

    public CheckResponseModifiedMap withCampaignStat(CampaignStatItem... campaignStat) {
        this.put(CAMPAIGN_STAT, campaignStat);
        return this;
    }
}
