package ru.yandex.autotests.directapi.model.api5.clients;

import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingUpdateEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingUpdateItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class ClientSettingUpdateItemMap extends ModelBeanMap<ClientSettingUpdateItemMap> {
    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public ClientSettingUpdateItemMap() {
        this(new ClientSettingUpdateItem());
    }

    public ClientSettingUpdateItemMap(ClientSettingUpdateEnum option, YesNoEnum value) {
        this();
        this.withOption(option).withValue(value);
    }

    public ClientSettingUpdateItemMap(ClientSettingUpdateItem clientSettingUpdateItem) {
        super();
        setBean(clientSettingUpdateItem);
    }

    public ClientSettingUpdateItemMap withOption(ClientSettingUpdateEnum element) {
        return put(OPTION, element);
    }

    public ClientSettingUpdateItemMap withValue(YesNoEnum value) {
        return put(VALUE, value);
    }
}
