package ru.yandex.autotests.directapi.model.api5.clients;

import com.yandex.direct.api.v5.generalclients.ClientUpdateItem;

import ru.yandex.autotests.directapi.model.api5.generalclients.ClientBaseItemMap;


public class ClientUpdateItemMap<T extends ClientUpdateItemMap> extends ClientBaseItemMap<T> {
    public static final String NOTIFICATION = "notification";
    public static final String SETTINGS = "settings";

    public ClientUpdateItemMap() {
        this(new ClientUpdateItem());
    }

    public ClientUpdateItemMap(ClientUpdateItem clientUpdateItem) {
        super();
        setBean(clientUpdateItem);
    }

    public T withNotification(NotificationUpdateMap notificationUpdateMap) {
        return putBeanMap(NOTIFICATION, notificationUpdateMap);
    }

    public T withSettings(ClientSettingUpdateItemMap... clientSettingUpdateItemMap) {
        return putBeanMapList(SETTINGS, clientSettingUpdateItemMap);
    }
}
