package ru.yandex.autotests.directapi.model.api5.clients;

import com.yandex.direct.api.v5.general.LangEnum;
import com.yandex.direct.api.v5.generalclients.NotificationUpdate;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.EmailSubscriptionItemMap;

public class NotificationUpdateMap extends ModelBeanMap<NotificationUpdateMap> {
    public static final String EMAIL_SUBSCRIPTIONS = "emailSubscriptions";
    public static final String EMAIL = "email";
    public static final String LANG = "lang";

    public NotificationUpdateMap() {
        this(new NotificationUpdate());
    }

    public NotificationUpdateMap(NotificationUpdate notificationUpdate) {
        super();
        setBean(notificationUpdate);
    }

    public NotificationUpdateMap withEmail(String email) {
        return put(EMAIL, email);
    }

    public NotificationUpdateMap withEmailSubscription(EmailSubscriptionItemMap... emailSubscriptionItem) {
        return putBeanMapList(EMAIL_SUBSCRIPTIONS, emailSubscriptionItem);
    }

    public NotificationUpdateMap withLang(LangEnum lang) {
        return put(LANG, lang);
    }
}
