package ru.yandex.autotests.directapi.model.api5.clients;

import com.yandex.direct.api.v5.clients.UpdateRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


public class UpdateRequestMap extends ModelBeanMap<UpdateRequestMap> {
    public static final String CLIENTS = "clients";

    public UpdateRequestMap() {
        this(new UpdateRequest());
    }

    public UpdateRequestMap(UpdateRequest request) {
        super();
        setBean(request);
    }

    public UpdateRequestMap withClients(ClientUpdateItemMap... clientUpdateItemMaps) {
        return putBeanMapList(CLIENTS, clientUpdateItemMaps);
    }
}
