package ru.yandex.autotests.directapi.model.api5.creatives;

import com.yandex.direct.api.v5.creatives.CpcVideoCreativeGet;
import com.yandex.direct.api.v5.creatives.CpmVideoCreativeGet;
import com.yandex.direct.api.v5.creatives.CreativeGetItem;
import com.yandex.direct.api.v5.creatives.CreativeTypeEnum;
import com.yandex.direct.api.v5.creatives.VideoExtensionCreativeGet;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class CreativeGetItemMap extends ModelBeanMap<CreativeGetItemMap> {

    public static final String ID = "id";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String PREVIEW_URL = "previewUrl";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String THUMBNAIL_URL = "thumbnailUrl";
    public static final String ASSOCIATED = "associated";
    public static final String IS_ADAPTIVE = "isAdaptive";
    public static final String VIDEO_EXTENSION_CREATIVE = "videoExtensionCreative";
    public static final String CPC_VIDEO_CREATIVE = "cpcVideoCreative";
    public static final String CPM_VIDEO_CREATIVE = "cpmVideoCreative";

    public CreativeGetItemMap() {
        super();
        setBean(new CreativeGetItem());
    }

    public CreativeGetItemMap(CreativeGetItem creativeGetItem) {
        super();
        setBean(creativeGetItem);
    }

    public CreativeGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CreativeGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public CreativeGetItemMap withType(CreativeTypeEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public CreativeGetItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public CreativeGetItemMap witAssociated(YesNoEnum associated) {
        this.put(ASSOCIATED, associated);
        return this;
    }

    public CreativeGetItemMap withPreviewUrl(String previewUrl) {
        this.put(PREVIEW_URL, previewUrl);
        return this;
    }

    public CreativeGetItemMap withWidth(Integer width) {
        this.put(WIDTH, width);
        return this;
    }

    public CreativeGetItemMap withHeight(Integer height) {
        this.put(HEIGHT, height);
        return this;
    }

    public CreativeGetItemMap withThumbnailUrl(String thumbnailUrl) {
        this.put(THUMBNAIL_URL, thumbnailUrl);
        return this;
    }

    public CreativeGetItemMap withIsAdaptive(YesNoEnum isAdaptive) {
        this.put(IS_ADAPTIVE, isAdaptive);
        return this;
    }

    public CreativeGetItemMap withVideoExtensionCreative(VideoExtensionCreativeGetItemMap videoExtensionCreativeMap) {
        VideoExtensionCreativeGet videoExtensionGetItem = videoExtensionCreativeMap == null
                ? null
                : ((VideoExtensionCreativeGet) videoExtensionCreativeMap.getBean());

        this.put(VIDEO_EXTENSION_CREATIVE, videoExtensionGetItem);
        return this;
    }

    public CreativeGetItemMap withCpcVideoCreative(CpcVideoCreativeGetItemMap cpcVideoCreativeMap) {
        CpcVideoCreativeGet cpcVideoCreativeGet = cpcVideoCreativeMap == null
                ? null
                : ((CpcVideoCreativeGet) cpcVideoCreativeMap.getBean());

        this.put(CPC_VIDEO_CREATIVE, cpcVideoCreativeGet);
        return this;
    }

    public CreativeGetItemMap withCpmVideoCreative(CpmVideoCreativeGetItemMap cpmVideoCreativeMap) {
        CpmVideoCreativeGet cpmVideoCreativeGet = cpmVideoCreativeMap == null
                ? null
                : ((CpmVideoCreativeGet) cpmVideoCreativeMap.getBean());

        this.put(CPM_VIDEO_CREATIVE, cpmVideoCreativeGet);
        return this;
    }
}
