package ru.yandex.autotests.directapi.model.api5.creatives;

import java.util.Arrays;

import com.yandex.direct.api.v5.creatives.CreativesSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class CreativesSelectionCriteriaMap extends ModelBeanMap<CreativesSelectionCriteriaMap> {
    public static final String IDS = "ids";
    public static final String TYPES = "types";

    public CreativesSelectionCriteriaMap() {
        super();
        setBean(new CreativesSelectionCriteria());
    }

    public CreativesSelectionCriteriaMap(CreativesSelectionCriteria creativesSelectionCriteria) {
        super();
        setBean(creativesSelectionCriteria);
    }

    public CreativesSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CreativesSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }
}
