package ru.yandex.autotests.directapi.model.api5.creatives;

import java.util.Arrays;

import com.yandex.direct.api.v5.creatives.CpcVideoCreativeFieldEnum;
import com.yandex.direct.api.v5.creatives.CpmVideoCreativeFieldEnum;
import com.yandex.direct.api.v5.creatives.CreativeFieldEnum;
import com.yandex.direct.api.v5.creatives.GetRequest;
import com.yandex.direct.api.v5.creatives.VideoExtensionCreativeFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String VIDEO_EXTENSION_CREATIVE_FIELD_NAMES = "videoExtensionCreativeFieldNames";
    public static final String CPC_VIDEO_CREATIVE_FIELD_NAMES = "cpcVideoCreativeFieldNames";
    public static final String CPM_VIDEO_CREATIVE_FIELD_NAMES = "cpmVideoCreativeFieldNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(CreativesSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(CreativeFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withFieldNames(String... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withVideoExtensionFieldNames(
            VideoExtensionCreativeFieldEnum... videoExtensionCreativeFieldEnums)
    {
        this.put(VIDEO_EXTENSION_CREATIVE_FIELD_NAMES, Arrays.asList(videoExtensionCreativeFieldEnums));
        return this;
    }

    public GetRequestMap withCpcVideoCreativeFieldNames(CpcVideoCreativeFieldEnum... cpcVideoCreativeFieldNames) {
        this.put(CPC_VIDEO_CREATIVE_FIELD_NAMES, Arrays.asList(cpcVideoCreativeFieldNames));
        return this;
    }

    public GetRequestMap withCpmVideoCreativeFieldNames(CpmVideoCreativeFieldEnum... cpmVideoCreativeFieldNames) {
        this.put(CPM_VIDEO_CREATIVE_FIELD_NAMES, Arrays.asList(cpmVideoCreativeFieldNames));
        return this;
    }
}
