package ru.yandex.autotests.directapi.model.api5.dictionaries;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Created by proxeter on 10.02.16.
 */
public enum DictionariesTextResources implements ITextResource {

    MEDICINE_ADCATEGORY_MESSAGE,
    MEDICINE_ADCATEGORY_DESCRIPTION,

    PRODUCTIVITY_ASSERTION_KEYWORD_RECOMMENDATION,
    PRODUCTIVITY_ASSERTION_KEYWORD_TITLE,

    LENIN_SQUARE,

    GEO_REGIONS_WORLD_NAME,
    GEO_REGIONS_WORLD_TYPE,
    GEO_REGIONS_CRIMEA_NAME,
    GEO_REGIONS_CRIMEA_TYPE,

    EUROPE_MOSCOW,
    SOUTH_OSSETIA;

    private static String BUNDLE = "api.dictionaries";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }

    public String text() {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(this)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());
        return resourceFormatter.toString();
    }

    public String text(String locale) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(this).locale(locale);
        return resourceFormatter.toString();
    }

}
