package ru.yandex.autotests.directapi.model.api5.dictionaries;

import java.util.Arrays;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by proxeter on 25.01.16.
 */
public class GetRequestMap extends ModelBeanMap<GetRequestMap> {

    public static final String DICTIONARY_NAMES = "dictionaryNames";

    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withDictionaryNames(String... fieldNames) {
        this.put(DICTIONARY_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withDictionaryNames(DictionaryNameEnum... fieldNames) {
        this.put(DICTIONARY_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllFieldNames() {
        this.put(DICTIONARY_NAMES, Arrays.asList(DictionaryNameEnum.class.getEnumConstants()));
        return this;
    }

}
