package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 28/08/15.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String WEBPAGES = "webpages";
    public static final String ADD_REQUEST = "addRequest";

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest webpageAddRequest) {
        super();
        setBean(webpageAddRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withWebpages(WebpageAddItemMap... webpageAddItems) {
        this.put(WEBPAGES, (webpageAddItems == null)
                ? null
                : Arrays.asList(webpageAddItems).stream()
                        .map(WebpageAddItemMap::getBean)
                        .collect(Collectors.toList())
        );
        return this;
    }
}
