package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import com.yandex.direct.api.v5.dynamictextadtargets.DeleteRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by buhter on 28/08/15.
 */
public class DeleteRequestMap extends ModelBeanMap<DeleteRequestMap> {

    public static final String DELETE_REQUEST = "deleteRequest";
    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public DeleteRequestMap() {
        super();
        setBean(new DeleteRequest());
    }

    public DeleteRequestMap(DeleteRequest webpageDeleteRequest) {
        super();
        setBean(webpageDeleteRequest);
    }

    public DeleteRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DeleteRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
