package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.GetRequest;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by buhter on 28/08/15.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";

//    protected WebpagesSelectionCriteria selectionCriteria;
//    protected List<WebpageFieldEnum> fieldNames;


    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest webpageGetRequest) {
        super();
        setBean(webpageGetRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(WebpagesSelectionCriteriaMap webpagesSelectionCriteriaMap) {
        this.put(SELECTION_CRITERIA, (webpagesSelectionCriteriaMap == null) ? null
                : webpagesSelectionCriteriaMap.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(WebpageFieldEnum... webpageFieldEnums) {
        this.put(FIELD_NAMES, Arrays.asList(webpageFieldEnums));
        return this;
    }
}
