package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import com.yandex.direct.api.v5.dynamictextadtargets.ResumeRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by buhter on 28/08/15.
 */
public class ResumeRequestMap extends ModelBeanMap<ResumeRequestMap> {

    public static final String RESUME_REQUEST = "resumeRequest";
    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public ResumeRequestMap() {
        super();
        setBean(new ResumeRequest());
    }

    public ResumeRequestMap(ResumeRequest webpageResumeRequest) {
        super();
        setBean(webpageResumeRequest);
    }

    public ResumeRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ResumeRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
