package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import com.yandex.direct.api.v5.dynamictextadtargets.SetBidsItem;
import com.yandex.direct.api.v5.general.PriorityEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 10.11.15.
 */
public class SetBidsItemMap extends ModelBeanMap<SetBidsItemMap> {

    public static final String CAMPAIGN_ID = "campaignId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String ID = "id";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";

    public SetBidsItemMap() {
        super();
        setBean(new SetBidsItem());
    }

    public SetBidsItemMap(SetBidsItem setBidsItem) {
        super();
        setBean(setBidsItem);
    }

    public SetBidsItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public SetBidsItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public SetBidsItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public SetBidsItemMap withBid(Long bid) {
        this.put(BID, bid);
        return this;
    }

    public SetBidsItemMap withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public SetBidsItemMap withStrategyPriority(PriorityEnum strategyPriority) {
        this.put(STRATEGY_PRIORITY, strategyPriority);
        return this;
    }
}
