package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.dynamictextadtargets.SetBidsRequest;
import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by semkagtn on 10.11.15.
 */
public class SetBidsRequestMap extends ModelBeanMap<SetBidsRequestMap> {

    public static final String BIDS = "bids";

    public SetBidsRequestMap() {
        super();
        setBean(new SetBidsRequest());
    }

    public SetBidsRequestMap(SetBidsRequest webpageSetBidsRequest) {
        super();
        setBean(webpageSetBidsRequest);
    }

    public SetBidsRequestMap withBids(SetBidsItemMap... bids) {
        this.put(BIDS, bids != null
                ? Stream.of(bids).map(BeanMap::getBean).collect(Collectors.toList())
                : null);
        return this;
    }
}
