package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import com.yandex.direct.api.v5.dynamictextadtargets.SuspendRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by buhter on 28/08/15.
 */
public class SuspendRequestMap extends ModelBeanMap<SuspendRequestMap> {

    public static final String SUSPEND_REQUEST = "suspendRequest";
    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public SuspendRequestMap() {
        super();
        setBean(new SuspendRequest());
    }

    public SuspendRequestMap(SuspendRequest webpageSuspendRequest) {
        super();
        setBean(webpageSuspendRequest);
    }

    public SuspendRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SuspendRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA, (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
