package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageAddItem;
import com.yandex.direct.api.v5.general.PriorityEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 28/08/15.
 */
public class WebpageAddItemMap extends ModelBeanMap<WebpageAddItemMap> {

    public static final String NAME = "name";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CONDITIONS = "conditions";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";

    public static final String DEFAULT_NAME = "DefaultWebpageName";

    public WebpageAddItemMap() {
        super();
        setBean(new WebpageAddItem());
    }

    public WebpageAddItemMap(WebpageAddItem webpageAddItem) {
        super();
        setBean(webpageAddItem);
    }

    public WebpageAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public WebpageAddItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public WebpageAddItemMap withAdGroupId(long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public WebpageAddItemMap withConditions(WebpageConditionMap... webpageConditions) {
        this.put(CONDITIONS,
                (webpageConditions == null)
                        ? null
                        : Arrays.asList(webpageConditions).stream()
                                .map(WebpageConditionMap::getBean)
                                .collect(Collectors.toList())
        );
        return this;
    }

    public WebpageAddItemMap withBid(Long bid) {
        this.put(BID, bid);
        return this;
    }

    public WebpageAddItemMap withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public WebpageAddItemMap withStrategyPriority(PriorityEnum strategyPriority) {
        this.put(STRATEGY_PRIORITY, strategyPriority);
        return this;
    }

    public WebpageAddItemMap defaultWebpage(Long adGroupId) {
        return withAdGroupId(adGroupId)
                .withName(DEFAULT_NAME);
    }
}
