package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageCondition;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 28/08/15.
 */
public class WebpageConditionMap extends ModelBeanMap<WebpageConditionMap> {

    public static final String OPERAND = "operand";
    public static final String OPERATOR = "operator";
    public static final String ARGUMENTS = "arguments";

    public static final Integer MAX_ARGUMENTS_AMOUNT = 10;
    public static final Integer MAX_LENGTH_OF_OFFERS_LIST_URL_ARGUMENT = 1024;
    public static final Integer MAX_LENGTH_OF_OTHER_OPERAND_ARGUMENT = 100;

    public WebpageConditionMap() {
        super();
        setBean(new WebpageCondition());
    }

    public WebpageConditionMap(WebpageCondition webpageCondition) {
        super();
        setBean(webpageCondition);
    }

    public WebpageConditionMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public WebpageConditionMap withOperand(WebpageConditionOperandEnum operand) {
        this.put(OPERAND, operand);
        return this;
    }

    public WebpageConditionMap withOperator(StringConditionOperatorEnum operator) {
        this.put(OPERATOR, operator);
        return this;
    }

    public WebpageConditionMap withArguments(String... arguments) {
        this.put(ARGUMENTS, Arrays.asList(arguments));
        return this;
    }

    public WebpageConditionMap defaultWebpage() {
        return this.withArguments("default webpage")
                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT);
    }
}
