package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.dynamictextadtargets.ObjectFactory;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageGetItem;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageTypeEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.StateEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 28/08/15.
 */
public class WebpageGetItemMap extends ModelBeanMap<WebpageGetItemMap> {

    public static final String ID = "id";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String NAME = "name";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String STATE = "state";
    public static final String STATUS_CLARIFICATION = "statusClarification";
    public static final String CONDITIONS = "conditions";
    public static final String CONDITION_TYPE = "conditionType";

    public WebpageGetItemMap() {
        super();
        setBean(new WebpageGetItem());
    }

    public WebpageGetItemMap(WebpageGetItem webpageGetItem) {
        super();
        setBean(webpageGetItem);
    }

    public WebpageGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public WebpageGetItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public WebpageGetItemMap withId(Long id) {
        this.put(ID, id);
        return this;
    }

    public WebpageGetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public WebpageGetItemMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public WebpageGetItemMap withBid(Long bid) {
        this.put(BID, bid);
        return this;
    }

    public WebpageGetItemMap withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public WebpageGetItemMap withStrategyPriority(PriorityEnum strategyPriority) {
        JAXBElement<PriorityEnum> jaxbElement
                = new ObjectFactory().createWebpageGetItemStrategyPriority(strategyPriority);
        this.put(STRATEGY_PRIORITY, jaxbElement);
        return this;
    }

    public WebpageGetItemMap withState(StateEnum state) {
        this.put(STATE, state);
        return this;
    }

    public WebpageGetItemMap withStatusClarification(String statusClarification) {
        this.put(STATUS_CLARIFICATION, statusClarification);
        return this;
    }

    public WebpageGetItemMap withConditionType(WebpageTypeEnum conditionType) {
        this.put(CONDITION_TYPE, conditionType);
        return this;
    }

    public WebpageGetItemMap withConditions(WebpageConditionMap... webpageConditions) {
        this.put(CONDITIONS, (webpageConditions == null) ? null
                : Stream.of(webpageConditions).map(WebpageConditionMap::getBean).collect(Collectors.toList()));
        return this;
    }
}
