package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageTypeEnum;
import com.yandex.direct.api.v5.general.AdTargetStateSelectionEnum;
import com.yandex.direct.api.v5.general.AdTargetsSelectionCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 28/08/15.
 */
public class WebpagesSelectionCriteriaMap extends ModelBeanMap<WebpagesSelectionCriteriaMap> {

    public static final String NAME = "name";
    public static final String STATES = "states";
    public static final String CONDITION_TYPE = "conditionType";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String AD_GROUP_IDS = "adGroupIds";
    public static final String IDS = "ids";

    public WebpagesSelectionCriteriaMap() {
        super();
        setBean(new AdTargetsSelectionCriteria());
    }

    public WebpagesSelectionCriteriaMap(AdTargetsSelectionCriteria webpagesSelectionCriteria) {
        super();
        setBean(webpagesSelectionCriteria);
    }

    public WebpagesSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public WebpagesSelectionCriteriaMap withName(String name) {
        this.put(NAME, name);
        return this;
    }

    public WebpagesSelectionCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }

    public WebpagesSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(AD_GROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public WebpagesSelectionCriteriaMap withCampaignIds(Long... campaignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(campaignIds));
        return this;
    }

    public WebpagesSelectionCriteriaMap withStates(AdTargetStateSelectionEnum... states) {
        this.put(STATES, Arrays.asList(states));
        return this;
    }

    public WebpagesSelectionCriteriaMap withConditionType(WebpageTypeEnum type) {
        this.put(CONDITION_TYPE, Arrays.asList(type));
        return this;
    }

}
