package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.ActionResultBase;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by chicos on 17.07.15.
 */
public class ActionResultBaseMap<T extends ActionResultBaseMap> extends ModelBeanMap<T> {

    public static final String WARNINGS = "warnings";
    public static final String ERRORS = "errors";

    public ActionResultBaseMap() {
        super();
        setBean(new ActionResultBase());
    }

    public ActionResultBaseMap(ActionResultBase actionResultBase) {
        super();
        setBean(actionResultBase);
    }

    public T withWarnings(ExceptionNotificationMap... warnings) {
        return putBeanMapList(WARNINGS, warnings);
    }

    public T withErrors(ExceptionNotificationMap... errors) {
        return putBeanMapList(ERRORS, errors);
    }
}
