package ru.yandex.autotests.directapi.model.api5.general;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.ArrayOfInteger;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 25.08.15.
 */
public class ArrayOfIntegerMap extends ModelBeanMap<ArrayOfIntegerMap> {

    public static final String ITEMS = "items";

    public ArrayOfIntegerMap() {
        super();
        setBean(new ArrayOfInteger());
    }

    public ArrayOfIntegerMap(ArrayOfInteger arrayOfInteger) {
        super();
        setBean(arrayOfInteger);
    }

    public ArrayOfIntegerMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ArrayOfIntegerMap withItems(Integer... items) {
        this.put(ITEMS, Arrays.asList(items));
        return this;
    }
}
