package ru.yandex.autotests.directapi.model.api5.general;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.ArrayOfLong;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by hmepas on 07.09.17
 */
public class ArrayOfLongMap extends ModelBeanMap<ArrayOfLongMap> {
    public static final String ITEMS = "items";

    public ArrayOfLongMap() {
        super();
        setBean(new ArrayOfLong());
    }

    public ArrayOfLongMap(ArrayOfLong arrayOfLong) {
        super();
        setBean(arrayOfLong);
    }

    public ArrayOfLongMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ArrayOfLongMap withItems(Long... items) {
        this.put(ITEMS, Arrays.asList(items));
        return this;
    }
}
