package ru.yandex.autotests.directapi.model.api5.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.ArrayOfString;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author pavryabov
 * Date 20.08.14
 */
public class ArrayOfStringMap extends ModelBeanMap<ArrayOfStringMap> {

    public static final String ITEMS = "items";

    public ArrayOfStringMap() {
        super();
        setBean(new ArrayOfString());
    }

    public ArrayOfStringMap(ArrayOfString arrayOfString) {
        super();
        setBean(arrayOfString);
    }

    @Override
    public ArrayOfStringMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ArrayOfStringMap withItems(String... items) {
        this.put(ITEMS, Arrays.asList(items));
        return this;
    }

    public ArrayOfStringMap withItems(List<String> items) {
        this.put(ITEMS, new ArrayList<>(items));
        return this;
    }
}
