package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.AutotargetingCategoryArray;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

public class AutotargetingCategoryArrayMap extends ModelBeanMap<AutotargetingCategoryArrayMap> {

    public static final String ITEMS = "items";

    public AutotargetingCategoryArrayMap() {
        super();
        setBean(new AutotargetingCategoryArray());
    }

    public AutotargetingCategoryArrayMap(AutotargetingCategoryArray autotargetingCategoryArray) {
        super();
        setBean(autotargetingCategoryArray);
    }

    public AutotargetingCategoryArrayMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AutotargetingCategoryArrayMap withItems(AutotargetingCategoryMap... items) {
        this.put(ITEMS, (items == null) ? null : convert(items, new BeanMapToBeanConverter()));
        return this;
    }
}
