package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.AutotargetingCategoriesEnum;
import com.yandex.direct.api.v5.general.AutotargetingCategory;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


public class AutotargetingCategoryMap extends ModelBeanMap<AutotargetingCategoryMap> {

    public static final String CATEGORY = "category";
    public static final String VALUE = "value";

    public AutotargetingCategoryMap() {
        super();
        setBean(new AutotargetingCategory());
    }

    public AutotargetingCategoryMap(AutotargetingCategory autotargetingCategory) {
        super();
        setBean(autotargetingCategory);
    }

    public AutotargetingCategoryMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AutotargetingCategoryMap withCategory(AutotargetingCategoriesEnum category) {
        this.put(CATEGORY, category);
        return this;
    }

    public AutotargetingCategoryMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
