package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.ExceptionNotification;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class ExceptionNotificationMap extends ModelBeanMap<ExceptionNotificationMap> {

    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String DETAILS = "details";

    public ExceptionNotificationMap() {
        super();
        setBean(new ExceptionNotification());
    }

    public ExceptionNotificationMap(ExceptionNotification exceptionNotification) {
        super();
        setBean(exceptionNotification);
    }

    public ExceptionNotificationMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ExceptionNotificationMap withCode(int code) {
        this.put(CODE, code);
        return this;
    }

    public ExceptionNotificationMap withMessage(String message) {
        this.put(MESSAGE, message);
        return this;
    }

    public ExceptionNotificationMap withDetails(String details) {
        this.put(DETAILS, details);
        return this;
    }
}
