package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.ExtensionModeration;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 22.04.15.
 */
public class ExtensionModerationMap extends ModelBeanMap<ExtensionModerationMap> {

    public static final String STATUS = "status";
    public static final String STATUS_CLARIFICATION = "statusClarification";

    public ExtensionModerationMap() {
        super();
        setBean(new ExtensionModeration());
    }

    public ExtensionModerationMap(ExtensionModeration extensionModeration) {
        super();
        setBean(extensionModeration);
    }

    public ExtensionModerationMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ExtensionModerationMap withStatus(StatusEnum status) {
        this.put(STATUS, status);
        return this;
    }

    public ExtensionModerationMap withStatusClarification(String statusClarification) {
        this.put(STATUS_CLARIFICATION, statusClarification);
        return this;
    }
}
