package ru.yandex.autotests.directapi.model.api5.general;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.IdsCriteria;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author pavryabov
 * Date 25.06.14
 */
public class IdsCriteriaMap extends ModelBeanMap<IdsCriteriaMap> {

    public static final String IDS = "ids";

    public static final int IDS_MAX_LENGTH = 10000;
    public static final int VCARDS_IDS_MAX_LENGTH = 1000;
    public static final int SITELINKS_IDS_MAX_LENGTH = 1000;
    public static final int BID_MODIFIERS_IDS_MAX_LENGTH = 1000;
    public static final int CAMPAIGN_IDS_MAX_LENGTH = 1000;

    public IdsCriteriaMap() {
        super();
        setBean(new IdsCriteria());
    }

    public IdsCriteriaMap(IdsCriteria idsCriteria) {
        super();
        setBean(idsCriteria);
    }

    public IdsCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public IdsCriteriaMap withIds(Long... ids) {
        this.put(IDS, Arrays.asList(ids));
        return this;
    }
}
