package ru.yandex.autotests.directapi.model.api5.general;

import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

public class JavaOrPerlApi5Error {
    private Api5Error javaError;
    private Api5Error perlError;

    private JavaOrPerlApi5Error(Api5Error javaError, Api5Error perlError) {
        this.javaError = javaError;
        this.perlError = perlError;
    }

    public static JavaOrPerlApi5Error java(Api5Error javaError) {
        return new JavaOrPerlApi5Error(javaError, null);
    }

    public static JavaOrPerlApi5Error both(Api5Error error) {
        return new JavaOrPerlApi5Error(error, error);
    }

    /**
     * Полезняшка для довольно общего случая: ожидается один код ошибки,
     * но с разными шаблонами сообщения детализации, и с общими аргументами.
     */
    public static JavaOrPerlApi5Error expect(int code, Api5ErrorDetails perlDetails,
            Api5ErrorDetailsJava javaDetails, Object... args)
    {
        return JavaOrPerlApi5Error
                .java(new Api5Error(code, javaDetails, args))
                .perl(new Api5Error(code, perlDetails, args));
    }


    public Api5Error getJavaError() {
        return javaError;
    }

    public Api5Error getPerlError() {
        return perlError;
    }

    public JavaOrPerlApi5Error perl(Api5Error perlError) {
        this.perlError = perlError;
        return this;
    }

    /**
     * Фабрика широко распространённых вилок {@link JavaOrPerlApi5Error}.
     */
    public static final class Common {
        private Common() {
            // no instantiation
        }

        public static JavaOrPerlApi5Error maxIdsInSelectionCriteria(String field, int max) {
            return JavaOrPerlApi5Error
                    .java(
                            new Api5Error(4001, Api5ErrorDetailsJava.MAX_IDS_IN_SELECTION,
                                    path("selectionCriteria", field)))
                    .perl(
                            new Api5Error(4001,
                                    Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                                    capitalize(field), max));
        }

        public static JavaOrPerlApi5Error notClientInClientLogin() {
            return JavaOrPerlApi5Error
                    .java(new Api5Error(8000, Api5ErrorDetails.NOT_CLIENT_IN_CLIENT_LOGIN))
                    .perl(new Api5Error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN));
        }
    }
}
