package ru.yandex.autotests.directapi.model.api5.general;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;

import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.errors;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warnings;

public final class JavaOrPerlExpectedResult {
    private ExpectedResult javaResult;
    private ExpectedResult perlResult;

    private JavaOrPerlExpectedResult(ExpectedResult javaResult, ExpectedResult perlResult) {
        this.javaResult = javaResult;
        this.perlResult = perlResult;
    }

    public static JavaOrPerlExpectedResult java(ExpectedResult javaResult) {
        return new JavaOrPerlExpectedResult(javaResult, null);
    }

    public static JavaOrPerlExpectedResult both(ExpectedResult result) {
        return JavaOrPerlExpectedResult.java(result).perl(result);
    }

    /**
     * Полезняшка для довольно общего случая: ожидается один код ошибки,
     * но с разными шаблонами сообщения детализации, и с общими аргументами.
     */
    public static JavaOrPerlExpectedResult expect(int code, Api5ErrorDetails perlDetails,
            Api5ErrorDetailsJava javaDetails, Object... args)
    {
        return JavaOrPerlExpectedResult
                .java(errors(new Notification(code, javaDetails, args)))
                .perl(errors(new Notification(code, perlDetails, args)));
    }

    /**
     * Полезняшка для довольно общего случая: ожидается один код варнинга и один ID,
     * но с разными шаблонами сообщения детализации, и с общими аргументами.
     */
    public static JavaOrPerlExpectedResult expectWarnings(long id, int code, Api5ErrorDetails perlDetails,
            Api5ErrorDetailsJava javaDetails, Object... args)
    {
        return JavaOrPerlExpectedResult
                .java(warnings(id, new Notification(code, javaDetails, args)))
                .perl(warnings(id, new Notification(code, perlDetails, args)));
    }

    /**
     * Шорткат. Тот самый случай, когда details совпадают.
     */
    public static JavaOrPerlExpectedResult bothJavaAndPerl(int code, ITextResource details, Object... args) {
        return JavaOrPerlExpectedResult.both(errors(new Notification(code, details, args)));
    }

    public ExpectedResult getJavaResult() {
        return javaResult;
    }

    public ExpectedResult getPerlResult() {
        return perlResult;
    }

    public JavaOrPerlExpectedResult perl(ExpectedResult perlResult) {
        this.perlResult = perlResult;
        return this;
    }

    /**
     * Фабрика широко распространённых вилок {@link JavaOrPerlExpectedResult}.
     */
    public static final class Common {

        private Common() {
            // no instantiation
        }

        public static JavaOrPerlExpectedResult fieldMustBePositiveInteger(String field) {
            return fieldMustBePositiveInteger(5005, field);
        }

        public static JavaOrPerlExpectedResult fieldMustBePositiveInteger(int code, String field) {
            return expect(code,
                    Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                    Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                    field);
        }

        public static JavaOrPerlExpectedResult fieldLengthExceeded(String field, int maxLength) {
            return expect(5001,
                    Api5ErrorDetails.FIELD_SHOULD_NOT_BE_MORE_THAN,
                    Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                    field, maxLength);
        }
    }
}
