package ru.yandex.autotests.directapi.model.api5.general;

public final class JavaOrPerlSetBidsExpectedResult {
    private SetBidsExpectedResult javaResult;
    private SetBidsExpectedResult perlResult;

    private JavaOrPerlSetBidsExpectedResult(SetBidsExpectedResult javaResult, SetBidsExpectedResult perlResult) {
        this.javaResult = javaResult;
        this.perlResult = perlResult;
    }

    public static JavaOrPerlSetBidsExpectedResult java(SetBidsExpectedResult javaResult) {
        return new JavaOrPerlSetBidsExpectedResult(javaResult, null);
    }

    public static JavaOrPerlSetBidsExpectedResult both(SetBidsExpectedResult result) {
        return new JavaOrPerlSetBidsExpectedResult(result, result);
    }

    public SetBidsExpectedResult getJavaResult() {
        return javaResult;
    }

    public SetBidsExpectedResult getPerlResult() {
        return perlResult;
    }

    public JavaOrPerlSetBidsExpectedResult perl(SetBidsExpectedResult perlResult) {
        this.perlResult = perlResult;
        return this;
    }
}
