package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.LimitOffset;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Author pavryabov
 * Date 24.06.14
 */
public class LimitOffsetMap extends ModelBeanMap<LimitOffsetMap> {

    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";

    public static final Long LIMIT_MAX_LENGTH = 10000L;
    public static final Long LIMIT_OFFSET_MAX_LENGTH = 120000L;
    public static final long OFFSET_MAX_LENGTH = Integer.MAX_VALUE - LIMIT_MAX_LENGTH;

    public LimitOffsetMap() {
        super();
        setBean(new LimitOffset());
    }

    public LimitOffsetMap(LimitOffset limitOffset) {
        super();
        setBean(limitOffset);
    }

    public LimitOffsetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public LimitOffsetMap withLimit(Long limit) {
        this.put(LIMIT, limit);
        return this;
    }

    public LimitOffsetMap withOffset(Long offset) {
        this.put(OFFSET, offset);
        return this;
    }
}
