package ru.yandex.autotests.directapi.model.api5.general;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/**
 * Created by chicos on 25.07.14.
 */
public class NotificationDetailMatcher extends TypeSafeDiagnosingMatcher<String> {
    private final String START_CODE_REGEXP = "^#[0-9]*(: )?";
    private final String expectedDetail;

    public NotificationDetailMatcher(String expectedDetail) {
        this.expectedDetail = expectedDetail;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("notification details ignoring code '" + expectedDetail + "'");
    }

    protected boolean matchesSafely(String actualDetail, Description mismatchDescription) {
        boolean matchesResult = true;
        String actualNoCode;
        String expectedNoCode;

        if (expectedDetail == null) {
            matchesResult = actualDetail == null;
        } else if (actualDetail == null) {
            matchesResult = false;
        } else {
            actualNoCode = actualDetail.replaceFirst(START_CODE_REGEXP, "");
            expectedNoCode = expectedDetail.replaceFirst(START_CODE_REGEXP, "");
            matchesResult = actualNoCode.equals(expectedNoCode);
        }

        if (!matchesResult) {
            mismatchDescription.appendText("\nnotification details was '");
            mismatchDescription.appendText(actualDetail);
            mismatchDescription.appendText("'");
        }
        return matchesResult;
    }

    @Factory
    public static Matcher equalToIgnoringCode(String expectedDetail) {
        return new NotificationDetailMatcher(expectedDetail);
    }
}
