package ru.yandex.autotests.directapi.model.api5.general;

import java.util.ArrayList;
import java.util.List;

import com.yandex.direct.api.v5.general.ExceptionNotification;

import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.emptyIterable;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.model.api5.general.NotificationDetailMatcher.equalToIgnoringCode;

/**
 * Created by semkagtn on 23.11.15.
 */
public class SetBidsExpectedResult extends SetBidsActionResultMap {

    public SetBidsExpectedResult() {
        super();
    }

    private BeanCompareStrategy resultCompareStrategy;

    public static SetBidsExpectedResult successWithId() {
        return success(ID);
    }

    public static SetBidsExpectedResult successWithCampaignId() {
        return success(CAMPAIGN_ID);
    }

    public static SetBidsExpectedResult successWithAdGroupId() {
        return success(AD_GROUP_ID);
    }

    public static SetBidsExpectedResult success(String fieldName) {
        SetBidsExpectedResult map = new SetBidsExpectedResult();
        map.resultCompareStrategy = new BeanCompareStrategy()
                .putFieldMatcher(fieldName, notNullValue())
                .putFieldMatcher(WARNINGS, emptyIterable())
                .putFieldMatcher(ERRORS, emptyIterable());
        return map;
    }

    public static SetBidsExpectedResult warningsWithID(ExceptionNotificationMap... warnings) {
        return warnings(ID, warnings);
    }

    public static SetBidsExpectedResult warningsWithCampaignID(ExceptionNotificationMap... warnings) {
        return warnings(CAMPAIGN_ID, warnings);
    }

    public static SetBidsExpectedResult warningsWithAdGroupID(ExceptionNotificationMap... warnings) {
        return warnings(AD_GROUP_ID, warnings);
    }

    public static SetBidsExpectedResult warnings(String fieldName, ExceptionNotificationMap... warnings) {
        SetBidsExpectedResult map = new SetBidsExpectedResult();
        List<BeanEquals> expectedWarningMatchers = new ArrayList<>();

        //replace details matcher to ignore code in messages like '#82518511 Warning message detail here'
        for (ExceptionNotificationMap warning : warnings) {
            BeanCompareStrategy strategy = new BeanCompareStrategy();
            if (((ExceptionNotification) warning.getBean()).getDetails() == null) {
                strategy.putFieldMatcher(ExceptionNotificationMap.DETAILS, nullValue());
            }
            expectedWarningMatchers.add(
                    BeanEquals.beanEquals(warning.getBean())
                            .accordingStrategy(strategy)
            );
        }

        BeanEquals[] array = new BeanEquals[expectedWarningMatchers.size()];
        map.resultCompareStrategy = new BeanCompareStrategy()
                .putFieldMatcher(fieldName, notNullValue())
                .putFieldMatcher(WARNINGS, containsInAnyOrder(expectedWarningMatchers.toArray(array)))
                .putFieldMatcher(ERRORS, emptyIterable());
        map.withWarnings(warnings);
        return map;
    }

    public static SetBidsExpectedResult errors(ExceptionNotificationMap... errors) {
        SetBidsExpectedResult map = new SetBidsExpectedResult();
        List<BeanEquals> expectedErrorMatchers = new ArrayList<>();

        //replace details matcher to ignore code in messages like '#82518511 Error message detail here'
        for (ExceptionNotificationMap error : errors) {
            BeanCompareStrategy strategy = new BeanCompareStrategy();
            if (((ExceptionNotification) error.getBean()).getDetails() == null) {
                strategy.putFieldMatcher(ExceptionNotificationMap.DETAILS, nullValue());
            }
            expectedErrorMatchers.add(
                    BeanEquals.beanEquals(error.getBean())
                            .accordingStrategy(strategy)
            );
        }

        BeanEquals[] array = new BeanEquals[expectedErrorMatchers.size()];
        map.resultCompareStrategy = new BeanCompareStrategy()
                .putFieldMatcher(ID, nullValue())
                .putFieldMatcher(AD_GROUP_ID, nullValue())
                .putFieldMatcher(CAMPAIGN_ID, nullValue())
                .putFieldMatcher(WARNINGS, emptyIterable())
                .putFieldMatcher(ERRORS, containsInAnyOrder(expectedErrorMatchers.toArray(array)));
        map.withErrors(errors);
        return map;
    }

    public static SetBidsExpectedResult warningWithError(ExceptionNotificationMap warning,
            ExceptionNotificationMap error)
    {
        SetBidsExpectedResult map = new SetBidsExpectedResult();
        List<BeanEquals> expectedErrorMatchers = new ArrayList<>();
        List<BeanEquals> expectedWarningMatchers = new ArrayList<>();
        expectedErrorMatchers.add(
                BeanEquals.beanEquals(error.getBean())
                        .ignoreFields(ExceptionNotificationMap.DETAILS)
                        .accordingStrategy(new BeanCompareStrategy()
                                .putFieldMatcher(
                                        ExceptionNotificationMap.DETAILS,
                                        equalToIgnoringCode((String) error.get(ExceptionNotificationMap.DETAILS)))));
        expectedWarningMatchers.add(
                BeanEquals.beanEquals(warning.getBean())
                        .ignoreFields(ExceptionNotificationMap.DETAILS)
                        .accordingStrategy(new BeanCompareStrategy()
                                .putFieldMatcher(
                                        ExceptionNotificationMap.DETAILS,
                                        equalToIgnoringCode((String) warning.get(ExceptionNotificationMap.DETAILS)))));
        BeanEquals[] errorArray = new BeanEquals[1];
        BeanEquals[] warningArray = new BeanEquals[1];
        map.resultCompareStrategy =
                new BeanCompareStrategy()
                        .putFieldMatcher(WARNINGS, containsInAnyOrder(expectedWarningMatchers.toArray(warningArray)))
                        .putFieldMatcher(ERRORS, containsInAnyOrder(expectedErrorMatchers.toArray(errorArray)));
        map.withWarnings(warning);
        map.withErrors(error);
        return map;
    }

    public BeanCompareStrategy getActionResultCompareStrategy() {
        return resultCompareStrategy;
    }
}
