package ru.yandex.autotests.directapi.model.api5.general;

import com.yandex.direct.api.v5.general.Statistics;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by chicos on 08.10.2015.
 */
public class StatisticsMap extends ModelBeanMap<StatisticsMap> {

    public static final String CLICKS = "clicks";
    public static final String IMPRESSIONS = "impressions";

    public StatisticsMap() {
        super();
        setBean(new Statistics());
    }

    public StatisticsMap(Statistics statistics) {
        super();
        setBean(statistics);
    }

    public StatisticsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StatisticsMap withClicks(Long clicks) {
        this.put(CLICKS, clicks);
        return this;
    }

    public StatisticsMap withImpressions(Long impressions) {
        this.put(IMPRESSIONS, impressions);
        return this;
    }
}
