package ru.yandex.autotests.directapi.model.api5.generalclients;

import com.yandex.direct.api.v5.generalclients.ClientBaseItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by buhter on 10/02/16.
 */
public class ClientBaseItemMap<T extends ClientBaseItemMap> extends ModelBeanMap<T> {
    public static final String CLIENT_INFO = "clientInfo";
    public static final String PHONE = "phone";

    public ClientBaseItemMap() {
        super();
        setBean(new ClientBaseItem());
    }

    public T withClientInfo(String clientInfo) {
        return put(CLIENT_INFO, clientInfo);
    }

    public T withPhone(String phone) {
        return put(PHONE, phone);
    }
}
