package ru.yandex.autotests.directapi.model.api5.generalclients;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.general.CurrencyEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.BonusesItem;
import com.yandex.direct.api.v5.generalclients.ClientGetItem;
import com.yandex.direct.api.v5.generalclients.ObjectFactory;

/**
 * Created by buhter on 10/02/16.
 */
public class ClientGetItemMap extends ClientBaseItemMap<ClientGetItemMap> {
    public static final String LOGIN = "login";
    public static final String CLIENT_ID = "clientId";
    public static final String CREATED_AT = "createdAt";
    public static final String OVERDRAFT_SUM_AVAILABLE = "overdraftSumAvailable";
    public static final String CURRENCY = "currency";
    public static final String VAT_RATE = "vatRate";
    public static final String ACCOUNT_QUALITY = "accountQuality";
    public static final String ARCHIVED = "archived";
    public static final String NOTIFICATION = "notification";
    public static final String SETTINGS = "settings";
    public static final String RESTRICTIONS = "restrictions";
    public static final String GRANTS = "grants";
    public static final String BONUSES = "bonuses";
    public static final String REPRESENTATIVES = "representatives";
    public static final String TYPE = "type";
    public static final String COUNTRY_ID = "countryId";

    public ClientGetItemMap() {
        super();
        setBean(new ClientGetItem());
    }

    public ClientGetItemMap(ClientGetItem clientGetItem) {
        super();
        setBean(clientGetItem);
    }

    public ClientGetItemMap withLogin(String login) {
        return put(LOGIN, login);
    }

    public ClientGetItemMap withClientId(Long clientId) {
        return put(CLIENT_ID, clientId);
    }

    public ClientGetItemMap withCreatedAt(String createdAt) {
        return put(CREATED_AT, createdAt);
    }

    public ClientGetItemMap withOverdraftAvailable(Long overdraftAvailable) {
        return put(OVERDRAFT_SUM_AVAILABLE, overdraftAvailable);
    }

    public ClientGetItemMap withCurrency(CurrencyEnum currency) {
        return put(CURRENCY, currency);
    }

    public ClientGetItemMap withVatRate(BigDecimal vatRate) {
        return put(VAT_RATE, new ObjectFactory().createClientGetItemVatRate(vatRate));
    }

    public ClientGetItemMap withAccountQuality(BigDecimal accountQuality) {
        return put(ACCOUNT_QUALITY, new ObjectFactory().createClientGetItemAccountQuality(accountQuality));
    }

    public ClientGetItemMap withArchived(YesNoEnum archived) {
        return put(ARCHIVED, archived);
    }

    public ClientGetItemMap withNotification(NotificationGetMap notificationMap) {
        return putBeanMap(NOTIFICATION, notificationMap);
    }

    public ClientGetItemMap withSettings(ClientSettingGetItemMap... settingMaps) {
        return putBeanMapList(SETTINGS, settingMaps);
    }

    public ClientGetItemMap withRestrictions(ClientRestrictionItemMap... clientRestrictionItemMaps) {
        return putBeanMapList(RESTRICTIONS, clientRestrictionItemMaps);
    }

    public ClientGetItemMap withGrants(GrantGetItemMap... grants) {
        return putBeanMapList(GRANTS, grants);
    }

    public ClientGetItemMap withBonuses(BonusesItem bonuses) {
        return put(BONUSES, bonuses);
    }

    public ClientGetItemMap withRepresentatives(RepresentativeMap... representativeMaps) {
        return putBeanMapList(REPRESENTATIVES, representativeMaps);
    }

    public ClientGetItemMap withType(String type) {
        return put(TYPE, type);
    }

    public ClientGetItemMap withCountryId(Integer countryId) {
        return put(COUNTRY_ID, countryId);
    }
}
